<?php

namespace DevOwl\RealCookieBanner\Vendor\DevOwl\Multilingual;

// @codeCoverageIgnoreStart
\defined('ABSPATH') or die('No script kiddies please!');
// Avoid direct file request
// @codeCoverageIgnoreEnd
/**
 * List of ISO 3166-1 alpha2 codes.
 *
 * @see https://gist.github.com/ssskip/5a94bfcd2835bf1dea52
 * @internal
 */
class Iso3166OneAlpha2
{
    use UtilsProvider;
    /**
     * Get a mapping of code => country sorted by translation.
     */
    public static function getSortedCodes()
    {
        $codes = self::getCodes();
        \asort($codes);
        return $codes;
    }
    /**
     * Get a mapping of code => country.
     */
    public static function getCodes()
    {
        return ['AF' => \__('Afghanistan', DEVOWL_MULTILINGUAL_TD), 'AX' => \__('Aland Islands', DEVOWL_MULTILINGUAL_TD), 'AL' => \__('Albania', DEVOWL_MULTILINGUAL_TD), 'DZ' => \__('Algeria', DEVOWL_MULTILINGUAL_TD), 'AS' => \__('American Samoa', DEVOWL_MULTILINGUAL_TD), 'AD' => \__('Andorra', DEVOWL_MULTILINGUAL_TD), 'AO' => \__('Angola', DEVOWL_MULTILINGUAL_TD), 'AI' => \__('Anguilla', DEVOWL_MULTILINGUAL_TD), 'AQ' => \__('Antarctica', DEVOWL_MULTILINGUAL_TD), 'AG' => \__('Antigua And Barbuda', DEVOWL_MULTILINGUAL_TD), 'AR' => \__('Argentina', DEVOWL_MULTILINGUAL_TD), 'AM' => \__('Armenia', DEVOWL_MULTILINGUAL_TD), 'AW' => \__('Aruba', DEVOWL_MULTILINGUAL_TD), 'AU' => \__('Australia', DEVOWL_MULTILINGUAL_TD), 'AT' => \__('Austria', DEVOWL_MULTILINGUAL_TD), 'AZ' => \__('Azerbaijan', DEVOWL_MULTILINGUAL_TD), 'BS' => \__('Bahamas', DEVOWL_MULTILINGUAL_TD), 'BH' => \__('Bahrain', DEVOWL_MULTILINGUAL_TD), 'BD' => \__('Bangladesh', DEVOWL_MULTILINGUAL_TD), 'BB' => \__('Barbados', DEVOWL_MULTILINGUAL_TD), 'BY' => \__('Belarus', DEVOWL_MULTILINGUAL_TD), 'BE' => \__('Belgium', DEVOWL_MULTILINGUAL_TD), 'BZ' => \__('Belize', DEVOWL_MULTILINGUAL_TD), 'BJ' => \__('Benin', DEVOWL_MULTILINGUAL_TD), 'BM' => \__('Bermuda', DEVOWL_MULTILINGUAL_TD), 'BT' => \__('Bhutan', DEVOWL_MULTILINGUAL_TD), 'BO' => \__('Bolivia', DEVOWL_MULTILINGUAL_TD), 'BQ' => \__('Caribbean Netherlands', DEVOWL_MULTILINGUAL_TD), 'BA' => \__('Bosnia And Herzegovina', DEVOWL_MULTILINGUAL_TD), 'BW' => \__('Botswana', DEVOWL_MULTILINGUAL_TD), 'BV' => \__('Bouvet Island', DEVOWL_MULTILINGUAL_TD), 'BR' => \__('Brazil', DEVOWL_MULTILINGUAL_TD), 'IO' => \__('British Indian Ocean Territory', DEVOWL_MULTILINGUAL_TD), 'BN' => \__('Brunei Darussalam', DEVOWL_MULTILINGUAL_TD), 'BG' => \__('Bulgaria', DEVOWL_MULTILINGUAL_TD), 'BF' => \__('Burkina Faso', DEVOWL_MULTILINGUAL_TD), 'BI' => \__('Burundi', DEVOWL_MULTILINGUAL_TD), 'KH' => \__('Cambodia', DEVOWL_MULTILINGUAL_TD), 'CM' => \__('Cameroon', DEVOWL_MULTILINGUAL_TD), 'CA' => \__('Canada', DEVOWL_MULTILINGUAL_TD), 'CV' => \__('Cape Verde', DEVOWL_MULTILINGUAL_TD), 'CW' => \__('Curaçao', DEVOWL_MULTILINGUAL_TD), 'KY' => \__('Cayman Islands', DEVOWL_MULTILINGUAL_TD), 'CF' => \__('Central African Republic', DEVOWL_MULTILINGUAL_TD), 'TD' => \__('Chad', DEVOWL_MULTILINGUAL_TD), 'CL' => \__('Chile', DEVOWL_MULTILINGUAL_TD), 'CN' => \__('China', DEVOWL_MULTILINGUAL_TD), 'CX' => \__('Christmas Island', DEVOWL_MULTILINGUAL_TD), 'CC' => \__('Cocos (Keeling) Islands', DEVOWL_MULTILINGUAL_TD), 'CO' => \__('Colombia', DEVOWL_MULTILINGUAL_TD), 'KM' => \__('Comoros', DEVOWL_MULTILINGUAL_TD), 'CG' => \__('Congo', DEVOWL_MULTILINGUAL_TD), 'CD' => \__('Congo, Democratic Republic', DEVOWL_MULTILINGUAL_TD), 'CK' => \__('Cook Islands', DEVOWL_MULTILINGUAL_TD), 'CR' => \__('Costa Rica', DEVOWL_MULTILINGUAL_TD), 'CI' => \__('Cote D\'Ivoire', DEVOWL_MULTILINGUAL_TD), 'HR' => \__('Croatia', DEVOWL_MULTILINGUAL_TD), 'CU' => \__('Cuba', DEVOWL_MULTILINGUAL_TD), 'CY' => \__('Cyprus', DEVOWL_MULTILINGUAL_TD), 'CZ' => \__('Czech Republic', DEVOWL_MULTILINGUAL_TD), 'DK' => \__('Denmark', DEVOWL_MULTILINGUAL_TD), 'DJ' => \__('Djibouti', DEVOWL_MULTILINGUAL_TD), 'DM' => \__('Dominica', DEVOWL_MULTILINGUAL_TD), 'DO' => \__('Dominican Republic', DEVOWL_MULTILINGUAL_TD), 'EC' => \__('Ecuador', DEVOWL_MULTILINGUAL_TD), 'EG' => \__('Egypt', DEVOWL_MULTILINGUAL_TD), 'SV' => \__('El Salvador', DEVOWL_MULTILINGUAL_TD), 'SX' => \__('Sint Maarten', DEVOWL_MULTILINGUAL_TD), 'GQ' => \__('Equatorial Guinea', DEVOWL_MULTILINGUAL_TD), 'ER' => \__('Eritrea', DEVOWL_MULTILINGUAL_TD), 'EE' => \__('Estonia', DEVOWL_MULTILINGUAL_TD), 'ET' => \__('Ethiopia', DEVOWL_MULTILINGUAL_TD), 'FK' => \__('Falkland Islands (Malvinas)', DEVOWL_MULTILINGUAL_TD), 'FO' => \__('Faroe Islands', DEVOWL_MULTILINGUAL_TD), 'FJ' => \__('Fiji', DEVOWL_MULTILINGUAL_TD), 'FI' => \__('Finland', DEVOWL_MULTILINGUAL_TD), 'FR' => \__('France', DEVOWL_MULTILINGUAL_TD), 'GF' => \__('French Guiana', DEVOWL_MULTILINGUAL_TD), 'PF' => \__('French Polynesia', DEVOWL_MULTILINGUAL_TD), 'TF' => \__('French Southern and Antarctic Lands', DEVOWL_MULTILINGUAL_TD), 'GA' => \__('Gabon', DEVOWL_MULTILINGUAL_TD), 'GM' => \__('Gambia', DEVOWL_MULTILINGUAL_TD), 'GE' => \__('Georgia', DEVOWL_MULTILINGUAL_TD), 'DE' => \__('Germany', DEVOWL_MULTILINGUAL_TD), 'GH' => \__('Ghana', DEVOWL_MULTILINGUAL_TD), 'GI' => \__('Gibraltar', DEVOWL_MULTILINGUAL_TD), 'GR' => \__('Greece', DEVOWL_MULTILINGUAL_TD), 'GL' => \__('Greenland', DEVOWL_MULTILINGUAL_TD), 'GD' => \__('Grenada', DEVOWL_MULTILINGUAL_TD), 'GP' => \__('Guadeloupe', DEVOWL_MULTILINGUAL_TD), 'GU' => \__('Guam', DEVOWL_MULTILINGUAL_TD), 'GT' => \__('Guatemala', DEVOWL_MULTILINGUAL_TD), 'GG' => \__('Guernsey', DEVOWL_MULTILINGUAL_TD), 'GN' => \__('Guinea', DEVOWL_MULTILINGUAL_TD), 'GW' => \__('Guinea-Bissau', DEVOWL_MULTILINGUAL_TD), 'GY' => \__('Guyana', DEVOWL_MULTILINGUAL_TD), 'HT' => \__('Haiti', DEVOWL_MULTILINGUAL_TD), 'HM' => \__('Heard Island & Mcdonald Islands', DEVOWL_MULTILINGUAL_TD), 'VA' => \__('Holy See (Vatican City State)', DEVOWL_MULTILINGUAL_TD), 'HN' => \__('Honduras', DEVOWL_MULTILINGUAL_TD), 'HK' => \__('Hong Kong', DEVOWL_MULTILINGUAL_TD), 'HU' => \__('Hungary', DEVOWL_MULTILINGUAL_TD), 'IS' => \__('Iceland', DEVOWL_MULTILINGUAL_TD), 'IN' => \__('India', DEVOWL_MULTILINGUAL_TD), 'ID' => \__('Indonesia', DEVOWL_MULTILINGUAL_TD), 'IR' => \__('Iran, Islamic Republic Of', DEVOWL_MULTILINGUAL_TD), 'IQ' => \__('Iraq', DEVOWL_MULTILINGUAL_TD), 'IE' => \__('Ireland', DEVOWL_MULTILINGUAL_TD), 'IM' => \__('Isle Of Man', DEVOWL_MULTILINGUAL_TD), 'IL' => \__('Israel', DEVOWL_MULTILINGUAL_TD), 'IT' => \__('Italy', DEVOWL_MULTILINGUAL_TD), 'JM' => \__('Jamaica', DEVOWL_MULTILINGUAL_TD), 'JP' => \__('Japan', DEVOWL_MULTILINGUAL_TD), 'JE' => \__('Jersey', DEVOWL_MULTILINGUAL_TD), 'JO' => \__('Jordan', DEVOWL_MULTILINGUAL_TD), 'KZ' => \__('Kazakhstan', DEVOWL_MULTILINGUAL_TD), 'KE' => \__('Kenya', DEVOWL_MULTILINGUAL_TD), 'KI' => \__('Kiribati', DEVOWL_MULTILINGUAL_TD), 'KR' => \__('Korea', DEVOWL_MULTILINGUAL_TD), 'KP' => \__('North Korea', DEVOWL_MULTILINGUAL_TD), 'KW' => \__('Kuwait', DEVOWL_MULTILINGUAL_TD), 'KG' => \__('Kyrgyzstan', DEVOWL_MULTILINGUAL_TD), 'LA' => \__('Lao People\'s Democratic Republic', DEVOWL_MULTILINGUAL_TD), 'LV' => \__('Latvia', DEVOWL_MULTILINGUAL_TD), 'LB' => \__('Lebanon', DEVOWL_MULTILINGUAL_TD), 'LS' => \__('Lesotho', DEVOWL_MULTILINGUAL_TD), 'LR' => \__('Liberia', DEVOWL_MULTILINGUAL_TD), 'LY' => \__('Libyan Arab Jamahiriya', DEVOWL_MULTILINGUAL_TD), 'LI' => \__('Liechtenstein', DEVOWL_MULTILINGUAL_TD), 'LT' => \__('Lithuania', DEVOWL_MULTILINGUAL_TD), 'LU' => \__('Luxembourg', DEVOWL_MULTILINGUAL_TD), 'MO' => \__('Macao', DEVOWL_MULTILINGUAL_TD), 'MK' => \__('Macedonia', DEVOWL_MULTILINGUAL_TD), 'MG' => \__('Madagascar', DEVOWL_MULTILINGUAL_TD), 'MW' => \__('Malawi', DEVOWL_MULTILINGUAL_TD), 'MY' => \__('Malaysia', DEVOWL_MULTILINGUAL_TD), 'MV' => \__('Maldives', DEVOWL_MULTILINGUAL_TD), 'ML' => \__('Mali', DEVOWL_MULTILINGUAL_TD), 'MT' => \__('Malta', DEVOWL_MULTILINGUAL_TD), 'MH' => \__('Marshall Islands', DEVOWL_MULTILINGUAL_TD), 'MQ' => \__('Martinique', DEVOWL_MULTILINGUAL_TD), 'MR' => \__('Mauritania', DEVOWL_MULTILINGUAL_TD), 'MU' => \__('Mauritius', DEVOWL_MULTILINGUAL_TD), 'YT' => \__('Mayotte', DEVOWL_MULTILINGUAL_TD), 'MX' => \__('Mexico', DEVOWL_MULTILINGUAL_TD), 'FM' => \__('Federated States Of Micronesia', DEVOWL_MULTILINGUAL_TD), 'MD' => \__('Moldova', DEVOWL_MULTILINGUAL_TD), 'MC' => \__('Monaco', DEVOWL_MULTILINGUAL_TD), 'MN' => \__('Mongolia', DEVOWL_MULTILINGUAL_TD), 'ME' => \__('Montenegro', DEVOWL_MULTILINGUAL_TD), 'MS' => \__('Montserrat', DEVOWL_MULTILINGUAL_TD), 'MA' => \__('Morocco', DEVOWL_MULTILINGUAL_TD), 'MZ' => \__('Mozambique', DEVOWL_MULTILINGUAL_TD), 'MM' => \__('Myanmar', DEVOWL_MULTILINGUAL_TD), 'NA' => \__('Namibia', DEVOWL_MULTILINGUAL_TD), 'NR' => \__('Nauru', DEVOWL_MULTILINGUAL_TD), 'NP' => \__('Nepal', DEVOWL_MULTILINGUAL_TD), 'NL' => \__('Netherlands', DEVOWL_MULTILINGUAL_TD), 'AN' => \__('Netherlands Antilles', DEVOWL_MULTILINGUAL_TD), 'NC' => \__('New Caledonia', DEVOWL_MULTILINGUAL_TD), 'NZ' => \__('New Zealand', DEVOWL_MULTILINGUAL_TD), 'NI' => \__('Nicaragua', DEVOWL_MULTILINGUAL_TD), 'NE' => \__('Niger', DEVOWL_MULTILINGUAL_TD), 'NG' => \__('Nigeria', DEVOWL_MULTILINGUAL_TD), 'NU' => \__('Niue', DEVOWL_MULTILINGUAL_TD), 'NF' => \__('Norfolk Island', DEVOWL_MULTILINGUAL_TD), 'MP' => \__('Northern Mariana Islands', DEVOWL_MULTILINGUAL_TD), 'NO' => \__('Norway', DEVOWL_MULTILINGUAL_TD), 'OM' => \__('Oman', DEVOWL_MULTILINGUAL_TD), 'PK' => \__('Pakistan', DEVOWL_MULTILINGUAL_TD), 'PW' => \__('Palau', DEVOWL_MULTILINGUAL_TD), 'PS' => \__('Palestinian Territory, Occupied', DEVOWL_MULTILINGUAL_TD), 'PA' => \__('Panama', DEVOWL_MULTILINGUAL_TD), 'PG' => \__('Papua New Guinea', DEVOWL_MULTILINGUAL_TD), 'PY' => \__('Paraguay', DEVOWL_MULTILINGUAL_TD), 'PE' => \__('Peru', DEVOWL_MULTILINGUAL_TD), 'PH' => \__('Philippines', DEVOWL_MULTILINGUAL_TD), 'PN' => \__('Pitcairn', DEVOWL_MULTILINGUAL_TD), 'PL' => \__('Poland', DEVOWL_MULTILINGUAL_TD), 'PT' => \__('Portugal', DEVOWL_MULTILINGUAL_TD), 'PR' => \__('Puerto Rico', DEVOWL_MULTILINGUAL_TD), 'QA' => \__('Qatar', DEVOWL_MULTILINGUAL_TD), 'RE' => \__('Reunion', DEVOWL_MULTILINGUAL_TD), 'RO' => \__('Romania', DEVOWL_MULTILINGUAL_TD), 'RU' => \__('Russian Federation', DEVOWL_MULTILINGUAL_TD), 'RW' => \__('Rwanda', DEVOWL_MULTILINGUAL_TD), 'BL' => \__('Saint Barthelemy', DEVOWL_MULTILINGUAL_TD), 'SH' => \__('Saint Helena', DEVOWL_MULTILINGUAL_TD), 'KN' => \__('Saint Kitts And Nevis', DEVOWL_MULTILINGUAL_TD), 'LC' => \__('Saint Lucia', DEVOWL_MULTILINGUAL_TD), 'MF' => \__('Saint Martin', DEVOWL_MULTILINGUAL_TD), 'PM' => \__('Saint Pierre And Miquelon', DEVOWL_MULTILINGUAL_TD), 'VC' => \__('Saint Vincent And Grenadines', DEVOWL_MULTILINGUAL_TD), 'WS' => \__('Samoa', DEVOWL_MULTILINGUAL_TD), 'SM' => \__('San Marino', DEVOWL_MULTILINGUAL_TD), 'ST' => \__('Sao Tome And Principe', DEVOWL_MULTILINGUAL_TD), 'SA' => \__('Saudi Arabia', DEVOWL_MULTILINGUAL_TD), 'SN' => \__('Senegal', DEVOWL_MULTILINGUAL_TD), 'RS' => \__('Serbia', DEVOWL_MULTILINGUAL_TD), 'SC' => \__('Seychelles', DEVOWL_MULTILINGUAL_TD), 'SL' => \__('Sierra Leone', DEVOWL_MULTILINGUAL_TD), 'SG' => \__('Singapore', DEVOWL_MULTILINGUAL_TD), 'SK' => \__('Slovakia', DEVOWL_MULTILINGUAL_TD), 'SI' => \__('Slovenia', DEVOWL_MULTILINGUAL_TD), 'SB' => \__('Solomon Islands', DEVOWL_MULTILINGUAL_TD), 'SO' => \__('Somalia', DEVOWL_MULTILINGUAL_TD), 'ZA' => \__('South Africa', DEVOWL_MULTILINGUAL_TD), 'GS' => \__('South Georgia And Sandwich Isl.', DEVOWL_MULTILINGUAL_TD), 'ES' => \__('Spain', DEVOWL_MULTILINGUAL_TD), 'LK' => \__('Sri Lanka', DEVOWL_MULTILINGUAL_TD), 'SD' => \__('Sudan', DEVOWL_MULTILINGUAL_TD), 'SR' => \__('Suriname', DEVOWL_MULTILINGUAL_TD), 'SS' => \__('South Sudan', DEVOWL_MULTILINGUAL_TD), 'SJ' => \__('Svalbard And Jan Mayen', DEVOWL_MULTILINGUAL_TD), 'SZ' => \__('Swaziland', DEVOWL_MULTILINGUAL_TD), 'SE' => \__('Sweden', DEVOWL_MULTILINGUAL_TD), 'CH' => \__('Switzerland', DEVOWL_MULTILINGUAL_TD), 'SY' => \__('Syrian Arab Republic', DEVOWL_MULTILINGUAL_TD), 'TW' => \__('Taiwan', DEVOWL_MULTILINGUAL_TD), 'TJ' => \__('Tajikistan', DEVOWL_MULTILINGUAL_TD), 'TZ' => \__('Tanzania', DEVOWL_MULTILINGUAL_TD), 'TH' => \__('Thailand', DEVOWL_MULTILINGUAL_TD), 'TL' => \__('Timor-Leste', DEVOWL_MULTILINGUAL_TD), 'TG' => \__('Togo', DEVOWL_MULTILINGUAL_TD), 'TK' => \__('Tokelau', DEVOWL_MULTILINGUAL_TD), 'TO' => \__('Tonga', DEVOWL_MULTILINGUAL_TD), 'TT' => \__('Trinidad And Tobago', DEVOWL_MULTILINGUAL_TD), 'TN' => \__('Tunisia', DEVOWL_MULTILINGUAL_TD), 'TR' => \__('Turkey', DEVOWL_MULTILINGUAL_TD), 'TM' => \__('Turkmenistan', DEVOWL_MULTILINGUAL_TD), 'TC' => \__('Turks And Caicos Islands', DEVOWL_MULTILINGUAL_TD), 'TV' => \__('Tuvalu', DEVOWL_MULTILINGUAL_TD), 'UG' => \__('Uganda', DEVOWL_MULTILINGUAL_TD), 'UA' => \__('Ukraine', DEVOWL_MULTILINGUAL_TD), 'AE' => \__('United Arab Emirates', DEVOWL_MULTILINGUAL_TD), 'GB' => \__('United Kingdom', DEVOWL_MULTILINGUAL_TD), 'US' => \__('United States', DEVOWL_MULTILINGUAL_TD), 'UM' => \__('United States Outlying Islands', DEVOWL_MULTILINGUAL_TD), 'UY' => \__('Uruguay', DEVOWL_MULTILINGUAL_TD), 'UZ' => \__('Uzbekistan', DEVOWL_MULTILINGUAL_TD), 'VU' => \__('Vanuatu', DEVOWL_MULTILINGUAL_TD), 'VE' => \__('Venezuela', DEVOWL_MULTILINGUAL_TD), 'VN' => \__('Vietnam', DEVOWL_MULTILINGUAL_TD), 'VG' => \__('Virgin Islands, British', DEVOWL_MULTILINGUAL_TD), 'VI' => \__('Virgin Islands, U.S.', DEVOWL_MULTILINGUAL_TD), 'WF' => \__('Wallis And Futuna', DEVOWL_MULTILINGUAL_TD), 'XK' => \__('Kosovo', DEVOWL_MULTILINGUAL_TD), 'EH' => \__('Western Sahara', DEVOWL_MULTILINGUAL_TD), 'YE' => \__('Yemen', DEVOWL_MULTILINGUAL_TD), 'ZM' => \__('Zambia', DEVOWL_MULTILINGUAL_TD), 'ZW' => \__('Zimbabwe', DEVOWL_MULTILINGUAL_TD)];
    }
}
