<?php

/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
namespace Google\Site_Kit_Dependencies\Google\Service\AnalyticsData;

class DimensionExpression extends \Google\Site_Kit_Dependencies\Google\Model
{
    protected $concatenateType = \Google\Site_Kit_Dependencies\Google\Service\AnalyticsData\ConcatenateExpression::class;
    protected $concatenateDataType = '';
    protected $lowerCaseType = \Google\Site_Kit_Dependencies\Google\Service\AnalyticsData\CaseExpression::class;
    protected $lowerCaseDataType = '';
    protected $upperCaseType = \Google\Site_Kit_Dependencies\Google\Service\AnalyticsData\CaseExpression::class;
    protected $upperCaseDataType = '';
    /**
     * Used to combine dimension values to a single dimension. For example,
     * dimension "country, city": concatenate(country, ", ", city).
     *
     * @param ConcatenateExpression $concatenate
     */
    public function setConcatenate(\Google\Site_Kit_Dependencies\Google\Service\AnalyticsData\ConcatenateExpression $concatenate)
    {
        $this->concatenate = $concatenate;
    }
    /**
     * @return ConcatenateExpression
     */
    public function getConcatenate()
    {
        return $this->concatenate;
    }
    /**
     * Used to convert a dimension value to lower case.
     *
     * @param CaseExpression $lowerCase
     */
    public function setLowerCase(\Google\Site_Kit_Dependencies\Google\Service\AnalyticsData\CaseExpression $lowerCase)
    {
        $this->lowerCase = $lowerCase;
    }
    /**
     * @return CaseExpression
     */
    public function getLowerCase()
    {
        return $this->lowerCase;
    }
    /**
     * Used to convert a dimension value to upper case.
     *
     * @param CaseExpression $upperCase
     */
    public function setUpperCase(\Google\Site_Kit_Dependencies\Google\Service\AnalyticsData\CaseExpression $upperCase)
    {
        $this->upperCase = $upperCase;
    }
    /**
     * @return CaseExpression
     */
    public function getUpperCase()
    {
        return $this->upperCase;
    }
}
// Adding a class alias for backwards compatibility with the previous class name.
\class_alias(\Google\Site_Kit_Dependencies\Google\Service\AnalyticsData\DimensionExpression::class, 'Google\\Site_Kit_Dependencies\\Google_Service_AnalyticsData_DimensionExpression');
